
// have.js - Main have.js exports
module.exports = (function(undefined) {

  var assert = require('assert')
    , fmt    = require('util').format
    , log    = function() { } // require('util').log; // disabled
    ;

  var ARR_RX = /^(.+) a(rr(ay)?)?$/i
    , OR_RX  = /^(.+) or (.+)$/i
    , OPT_RX = /^opt(ional)? (.+)$/i;

  // core recursive check
  function ensure(argName, argType, value, check) {
    var memberType = null
      , valid      = true
      , reason     = null
      , match      = null
      , i          = 0;

    function softAssert(cond, reason_) { if (!(valid = cond)) reason = reason_; }
    function logMatch() { log(match[0]); }

    if (match = argType.match(OPT_RX)) {
      logMatch();
      memberType = match[2];

      ensure(argName, memberType, value, softAssert);

      // optional is consumed if it match or a null/undefined is given.
      return valid ||
        value === null ||
        value === undefined;
    }

    if (match = argType.match(OR_RX)) {
      logMatch();
      memberType = match[1];
      ensure(argName, memberType, value, softAssert);

      if (valid) return true;
      valid = true; // reset previous softAssert

      memberType = match[2];
      ensure(argName, memberType, value, softAssert);

      check(valid, fmt("%s argument is neither a %s nor %s",
        argName, match[1], match[2]));
      return true;
    }

    if (match = argType.match(ARR_RX)) {
      logMatch();
      ensure(argName, 'array', value, softAssert);

      if (!valid) {
        check(false, reason);
        return false;
      }

      memberType = match[1];
      for (i = 0; i < value.length; i++) {
        ensure(argName, memberType, value[i], softAssert);

        if (!valid) {
          check(false, fmt("%s element is falsy or not a %s", argName, memberType));
          return false;
        }
      }

      return true;
    }

    // atom types
    log(argType);
    switch(argType) {

      // basic types
      case 's': case 'str': case 'string':
        valid = typeof value === 'string'; break;

      case 'n': case 'num': case 'number':
        valid = typeof value === 'number'; break;

      case 'b': case 'bool': case 'boolean':
        valid = typeof value === 'boolean'; break;

      case 'f': case 'fun': case 'func': case 'function':
        valid = typeof value === 'function'; break;

      case 'a': case 'arr': case 'array':
        valid = value instanceof Array; break;

      case 'o': case 'obj': case 'object':
        valid = value && typeof value === 'object'; break;

      // built-in types
      case 'r': case 'rx': case 'regex': case 'regexp':
        valid = value && value instanceof RegExp; break;

      case 'd': case 'date': // TODO: case 't': case 'time': case 'datetime': // ?
        valid = value && value instanceof Date; break;

      default:
        valid = false; break;
    }

    check(valid, fmt("%s argument is not %s", argName, argType));
    return true;
  }

  // exports
  function have(args, schema) {
    if (!(args && typeof args === 'object' && 'length' in args))
      throw new Error('have() called with invalid arguments list');
    if (!(schema && typeof schema === 'object'))
      throw new Error('have() called with invalid schema object');

    var idx     = 0
      , argName = null
      , parsedArgs = { };

    for (argName in schema) {
      if (ensure(argName, schema[argName], args[idx], assert)) {
          parsedArgs[argName] = args[idx];
          idx++;
      }
    }

    return parsedArgs;
  };

  // configuration
  have.assert = function(assert_) {
    return (assert_ === undefined) ? assert : (assert = assert_);
  };

  return have;

})();

